<?php

class list_problema extends fs_list_controller{
    public function __construct($name = __CLASS__, $title = 'Problemas', $folder = 'FAQs', $admin = FALSE, $shmenu = TRUE, $important = FALSE) {
        parent::__construct($name, $title, $folder, $admin, $shmenu, $important);
    }
    
    protected function create_tabs() {
        $this->add_tab('problemas', 'Problemas', 'problemas');
        $this->add_sort_option('problemas', ['fecha']);
        
        ///columnas
        $this->decoration->add_column('problemas', 'fecha', 'date', 'Fecha alta', 'date');
        $this->decoration->add_column('problemas', 'categoria', 'string', 'Categoria');
        $this->decoration->add_column('problemas', 'sintomas', 'string', 'Síntomas', 'string');
        
        /*colores
        $this->decoration->add_row_option('problemas', 'nick', '', 'danger');*/
       
        ///clic
        $this->decoration->add_row_url('problemas', 'index.php?page=edit_problema&code=', 'idproblema');
        
        ///botones
        $this->add_button('problemas', 'Nuevo', 'index.php?page=edit_problema', 'fa-plus', 'btn-success');
        
        ///Búsquedas
        $this->add_search_columns('problemas', ['sintomas', 'causa', 'solucion', 'observaciones']);
        
        ///filtros
        $categorias = $this->sql_distinct('procategorias', 'categoria');
        $this->add_filter_select('problemas', 'categoria', 'Categoria', $categorias);
        
        $this->add_filter_date('problemas', 'fecha', 'Desde', '>=');
        $this->add_filter_date('problemas', 'fecha', 'Hasta', '<=');
    }

}
